/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.tile;

import gloridifice.watersource.common.tile.ModNormalTile;
import gloridifice.watersource.registry.TileEntityTypesRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WaterFilterDownTile
extends ModNormalTile {
    LazyOptional<FluidTank> downTank = LazyOptional.of(this::createFluidHandler);
    double cacheTimeEnter;
    double cacheTimeExit = 0.0;
    boolean previousIsIn = false;
    boolean isLeftAnimeEnd = true;
    int heightAmount = 0;
    final int capacity;

    public WaterFilterDownTile(int capacity) {
        super(TileEntityTypesRegistry.WATER_FILTER_DOWN_TILE);
        this.capacity = capacity;
    }

    public double getCacheTimeEnter() {
        return this.cacheTimeEnter;
    }

    public void setCacheTimeEnter(double cacheTimeEnter) {
        this.cacheTimeEnter = cacheTimeEnter;
    }

    public double getCacheTimeExit() {
        return this.cacheTimeExit;
    }

    public void setCacheTimeExit(double cacheTimeExit) {
        this.cacheTimeExit = cacheTimeExit;
    }

    public boolean isPreviousIsIn() {
        return this.previousIsIn;
    }

    public void setPreviousIsIn(boolean previousIsIn) {
        this.previousIsIn = previousIsIn;
    }

    public boolean isLeftAnimeEnd() {
        return this.isLeftAnimeEnd;
    }

    public void setLeftAnimeEnd(boolean leftAnimeEnd) {
        this.isLeftAnimeEnd = leftAnimeEnd;
    }

    public LazyOptional<FluidTank> getDownTank() {
        return this.downTank;
    }

    public int getFluidAmount() {
        return ((FluidTank)this.downTank.orElse(null)).getFluidAmount();
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.downTank.ifPresent(fluidTank -> fluidTank.readFromNBT(compound.func_74775_l("downTank")));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.downTank.ifPresent(fluidTank -> compound.func_218657_a("downTank", (INBT)fluidTank.writeToNBT(new CompoundNBT())));
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (!this.field_145846_f && CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.equals(cap)) {
            return this.downTank.cast();
        }
        return super.getCapability(cap, side);
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(this.capacity){

            protected void onContentsChanged() {
                WaterFilterDownTile.this.refresh();
                WaterFilterDownTile.this.func_70296_d();
                super.onContentsChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return !stack.getFluid().getAttributes().isLighterThanAir() && stack.getFluid().getAttributes().getTemperature() < 500;
            }
        };
    }

    private void updateHeight() {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            if (this.heightAmount > this.getFluidAmount()) {
                this.heightAmount -= Math.max(1, (this.heightAmount - this.getFluidAmount()) / 10);
            } else if (this.heightAmount < this.getFluidAmount()) {
                this.heightAmount += Math.max(1, (this.getFluidAmount() - this.heightAmount) / 10);
            }
        }
    }

    public float getHeight() {
        this.updateHeight();
        return 0.75f * (float)this.heightAmount / (float)this.capacity;
    }
}

